;==============================================================================
; BitCountFast
;------------------------------------------------------------------------------

; Bit counting using a 256-byte pre-calculated table.
;
;==============================================================================
; Revision History
;
; 13-08-2007 AJ First Release
;------------------------------------------------------------------------------
; $Id$
;------------------------------------------------------------------------------

                .6502

                .GLOBAL BitCountFast
                .GLOBAL BitCounts

                .CODE

; The fastest way of counting the bits in a byte is to use a lookup table of
; pre-calculated values.

BitCountFast:   TAX
                LDA BitCounts,X
                RTS

; Bit counts for values $00 to $7F

BitCounts       .BYTE 0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4
                .BYTE 1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5
                .BYTE 1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5
                .BYTE 2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
                .BYTE 1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5
                .BYTE 2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
                .BYTE 2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
                .BYTE 3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7
                .BYTE 1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5
                .BYTE 2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
                .BYTE 2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
                .BYTE 3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7
                .BYTE 2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
                .BYTE 3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7
                .BYTE 3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7
                .BYTE 4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8

                .END